<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PositionPhoto extends Model 
{

    protected $table = 'positions_photos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'photo_id', 'position_id');
    protected $visible = array('slug', 'photo_id', 'position_id');

    public function position()
    {
        return $this->belongsTo('App\Models\Position', 'position_id');
    }

    public function photo()
    {
        return $this->belongsTo('App\Models\Photo', 'photo_id');
    }

}